#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# This program belongs to AKKODIS INGENIERIE PRODUIT SAS.
# It is considered a trade secret, and is not to be divulged or used
# by parties who have not received written authorization from the owner.
#

# the main class
# basically a collection of values for installation
import sys,os
sys.path.append(os.path.dirname( os.path.realpath( __file__ ) ))
import infinite


class directoryInstallationInfos(infinite.commonInstallationInfos) :
	
	#object init
	def __init__(self) :
		infinite.commonInstallationInfos.__init__(self)

	## creates the folder hierarchy
	def createFolders (self) :
		infinite.createDirectoryFolders(self)

	def checkDirectoryInstallationSoftwares(self) :
		infinite.checkDirectoryInstallationSoftwares(self,[])

	def configureApache(self):
		infinite.configureApache(self)

	def installBinary (self) :
		if sys.platform == 'win32':
			params = {
				'Setup' : {
					'Lang' : 'en',
					'Dir' : self.directory_binary_folder,
					}
				}
		else :
			params = {
				'3djuump-infinite-directory/eula' : ('string', 'yes'),
			}
		infinite.installInfiniteBinary(self,self.directory_binary_installer,self.directory_service_name, params, [self.directory_binary_installer])
	
	def configureBinary(self):
		infinite.configureInfiniteService(self, self.directory_service_name, ['-createdirectorydb'])
	
	def startServices(self) :
		infinite.restartService(self.directory_service_name)

if __name__ == '__main__':
	import sys,os,time
	
	lTimeStart = time.time();
	
	# make sure we can import the required module
	os.chdir(os.path.dirname( os.path.realpath( __file__ ) ))
	
	lInfos = directoryInstallationInfos()
	
	# read from csv or from code
	lInfos.fromYaml('./form_directory.yaml','./validation_schema/schema_directory.json')
	
	# check admin rights
	lInfos.checkPrerequisites()
	
	lInfos.checkDirectoryInstallationSoftwares()
	
	lInfos.stopInfiniteServices()
	
	# install redistributables
	lInfos.prepareSystem()
	# create folder hierarchy
	lInfos.createFolders()
	# create ssl key certificate pair
	lInfos.createSSL()
	# install postgres
	lInfos.installPostgres()
	# configure postgres
	lInfos.configurePostgres()
	# install infinite directory
	lInfos.installBinary()
	# configure service
	lInfos.configureBinary()
	# install apache
	lInfos.installApache()
	# install apache plugins
	lInfos.installApachePlugins()
	# patch apache
	lInfos.patchApacheDirectory()
	# configure apache
	lInfos.configureApache()
	# start the services
	lInfos.startServices()
	
	lTimeEnd = time.time();
	
	print("Installation done in %d s" % int(lTimeEnd - lTimeStart))
	